	% EXAMPLE 8.4	 Cauer
	clear all
	close all
	Wc = 20000;
	Ws = 28400;
	r = 0.15;
	Amax = -10*log10(1 - r^2);
	Amin = 40;
	N = CA_ORDER_S(Wc, Ws, Amax, Amin)
	N = 5;			% We select a 5th-order filter
	Rs = 50;
	RL = 50;
	[G, Z, R_ZEROS, P, Wsnew] = CA_POLES_S(Wc, Ws, Amax, Amin, N);
	Ladder = 0; 				% 1 for a T ladder and 0 for a  ladder
	Type = 'a';
	[L, C, Rs, RL, W0, K] = CA_LADDER(G, Z, R_ZEROS, P, Wc, Ws, Amax, Amin, Rs, RL, Ladder, Type);
	Z0 = []; T = 1;				% Used only for transmission lines
	omega = [0:150000/2000:150000];
	H = LADDER_2_H(N, Z0, L, C, Rs, RL, K, omega, T);
	Anorm = MAG_2_ATT(H*2);		% Normalized attenuation to 0 dB
	subplot('position', [0.08 0.4 0.90 0.5]);
	PLOT_ATT_S(omega, Anorm); 
	%	PLOT_LP_SPEC_S(Wc, Ws, Amax, Amin); % Amin = 0 => No stopband spec
	axis([0, 150000, 0, 60]);
	L = L'
	C = C'
	w0 = W0'
	zoom on
	
